# PrestaPicqer Module

## Overview
PrestaPicqer is a powerful module that seamlessly integrates your PrestaShop store with Picqer warehouse management system. It automates the synchronization of orders and product stock levels, streamlining your e-commerce operations.

## Key Features
- **Automatic Order Sync**: New PrestaShop orders are automatically sent to Picqer
- **Status Updates**: Order statuses in PrestaShop are updated based on Picqer's fulfillment process
- **Stock Synchronization**: Keep product stock levels synchronized between PrestaShop and Picqer
- **Multi-store Support**: Works with multiple PrestaShop stores using unique prefixes
- **Webhook Integration**: Real-time updates via secure webhooks

## Requirements
- PrestaShop 1.7 or higher
- PHP 7.2 or higher
- Valid Picqer account with API access
- Webhook URL must be accessible from the internet

## Installation
1. Log in to your PrestaShop admin panel
2. Navigate to **Modules > Module Manager**
3. Click "Upload a module" and select the downloaded ZIP file
4. Click "Install" next to the PrestaPicqer module
5. Click "Configure" to set up the module

## Quick Start
1. Get your Picqer API key from Settings > API Keys
2. Enter your Picqer subdomain and API key in the module configuration
3. Configure order status mapping
4. Set up stock synchronization preferences
5. Test the connection and webhooks

## Documentation
For detailed documentation, see the [PrestaPicqer Guide](https://softerbv.nl/prestapicqer/docs)

## Support
For support, do not hesitate to contact our support team: softernl@protonmail.com
Please provide your PrestaShop version, PrestaPicqer version, and a detailed description of your issue.

## License
This module is proprietary software licensed under a Commercial License as laid out in the [PRESTAPICQER END USER LICENSE AGREEMENT](license.txt) provided with this module.
**License Restrictions:**
- Single PrestaShop installation only
- No redistribution or resale permitted
- No modification or reverse engineering allowed

Copyright © 2025 SofTer B.V.. All rights reserved.