# PrestaPicqer Module

## Overview
PrestaPicqer is a powerful module that seamlessly integrates your PrestaShop store with Picqer warehouse management system. It automates the synchronization of orders and product stock levels, streamlining your e-commerce operations.

![PrestaPicqer Configuration](docs/images/general.png)

## Key Features
- **Automatic Order Sync**: New PrestaShop orders are automatically sent to Picqer
- **Status Updates**: Order statuses in PrestaShop are updated based on Picqer's fulfillment process
- **Stock Synchronization**: Keep product stock levels synchronized between PrestaShop and Picqer
- **Multi-store Support**: Works with multiple PrestaShop stores using unique prefixes
- **Webhook Integration**: Real-time updates via secure webhooks

## Requirements
- PrestaShop 1.7 or higher
- PHP 7.2 or higher
- Valid Picqer account with API access
- Webhook URL must be accessible from the internet

## Installation
1. Download the latest version from [PrestaShop Addons](https://addons.prestashop.com)
2. Log in to your PrestaShop admin panel
3. Navigate to **Modules > Module Manager**
4. Click "Upload a module" and select the downloaded ZIP file
5. Click "Install" next to the PrestaPicqer module
6. Click "Configure" to set up the module

## Quick Start
1. Get your Picqer API key from Settings > API Keys
2. Enter your Picqer subdomain and API key in the module configuration
3. Configure order status mapping
4. Set up stock synchronization preferences
5. Test the connection and webhooks

## Documentation
For detailed documentation, see the `/docs` folder:
- [Installation Guide](docs/installation.md)
- [Configuration Guide](docs/configuration.md)
- [Usage Guide](docs/usage.md)
- [Troubleshooting](docs/troubleshooting.md)

## Support
For support, please use the official PrestaShop Addons support system:
- Log into your Addons account
- Go to "My Purchases"
- Find PrestaPicqer module and click "Contact the developer"

## License
This module is released under the Academic Free License (AFL 3.0)