# Configuration Guide

## Accessing Configuration
After installation, navigate to **Modules > Module Manager > PrestaPicqer > Configure**

## General Settings

![General Settings](images/general.png)

_General Settings in PrestaPicqer Configuration._

### Picqer Subdomain
Enter the subdomain of your Picqer URL (e.g., `yourcompany.picqer.com` - only `yourcompany` is needed).

### Picqer API Key
1. Log in to your Picqer account
2. Go to **Settings > API Keys** or visit [API Keys](https://redirect.picqer.com/config/apikeys)
3. Generate a new API key with write permissions
4. Copy and paste the API key into the module

### Shop Identifier Prefix
This is used to uniquely identify your PrestaShop store. You can choose a 1-3 characters long prefix. If you have a single PrestaShop store you can leave the default 'PS'. Do not change the shop prefix on a running system, if changed existing orders will not get updated anymore.

### Webhook URL
Picqer will try to communicate with PrestaShop by calling the Webhook URL shown. It is important that this URL is accessible from the internet.

## Order Configuration

![Orders Configuration](images/orders.png)

### Apply Tags to New Orders
Choose from the tags available in Picqer. If you create new tags in Picqer while the PrestaPicqer Configuration is open you need to refresh the page to be able to see the new tags.

### Use PrestaShop Product Price
Use this to send the PrestaShop product price with the order to Picqer. PrestaPicqer will try to find the matching VAT in Picqer.

### Create New Order in Picqer
Choose the PrestaShop order status(es) that will create a new order in Picqer.

### Initial Order Status in Picqer
New orders in Picqer are always created with the status "Concept". With this option you can choose whether or not to update the status of the Picqer order to "Processing" directly after creating a new order. Only orders that are ready to be handled by the warehouse will be created in Picqer.

When "Concept" is selected, two extra options will appear:
- Choose whether to allocate stock for "Concept" orders
- Select which PrestaShop order status(es) to update the order status in Picqer to "Processing"

### Cancel Orders in Picqer
Choose the PrestaShop order status(es) that will cancel the order in Picqer. The Picqer order will be forcefully cancelled, this means that even when the order has already shipped the status will still be updated to "Cancelled".

### Order Status Mapping
This table is used to match a status in PrestaShop to a status in Picqer. When an order's status changes in Picqer (e.g., "Completed"), PrestaPicqer can update the status of the corresponding order in PrestaShop.

### Webhook Status
In order for Picqer to update the status of an order in PrestaShop it needs an active webhook. Here you can see the status of the webhook that handles changes made to orders in Picqer. If the webhook status is "Inactive" you can use the button to create a webhook.

## Stock Configuration

![Stock Configuration](images/stock.png)

### Full Catalogue Stock Sync
This setting enables you to have the full product catalogue to be synchronized every time a single product's stock changes. This option ensures a fully synchronized stock but can take too much time on a big product catalogue.

### Full Stock Sync URL
This is the URL you can call to make an update of your full catalogue. This can be handy for a scheduled stock update, e.g. using Curl in a Cron job.

### Webhook Status
In order for Picqer to update the stock in PrestaShop it needs an active webhook. Here you can see the status of the webhook that handles stock changes in Picqer.

## Testing Configuration
1. Save all settings
2. Test the connection using the provided test button
3. Create a test order to verify synchronization
4. Check webhook logs in Picqer for successful calls