<div class="panel">
    <div class="panel-heading">
     
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" viewBox="120 0 750 680" xml:space="preserve" style="width: 60px; margin-bottom: -5px;">
            <path fill="#2C0161" opacity="1.000000" stroke="none" d="M615.406616,110.532318 C642.914856,129.083466 660.615723,154.161682 667.304688,186.287659 C680.993896,252.034317 651.890198,310.625275 592.151550,339.271301 C569.643738,350.064331 545.625610,354.091583 520.970642,354.261963 C474.812531,354.580963 428.650818,354.397247 382.490601,354.388245 C373.211761,354.386444 369.859222,351.104340 369.460632,341.974457 C368.893646,328.987732 368.692841,316.003479 369.609589,303.022888 C370.109222,295.948517 373.265289,292.797333 380.356720,292.693146 C388.687134,292.570740 397.020660,292.655334 405.352814,292.655121 C438.848175,292.654358 472.344208,292.785950 505.838593,292.606812 C525.877502,292.499664 544.795105,287.922974 561.423767,276.225861 C577.092407,265.204071 586.017395,249.962463 588.696167,230.990738 C590.754456,216.414536 590.072510,202.066040 584.461975,188.353104 C576.341309,168.504974 560.862427,157.090027 540.613586,151.619247 C532.080444,149.313766 523.305237,148.401764 514.483765,148.398376 C412.497894,148.359253 310.512024,148.375717 208.526169,148.366837 C195.819168,148.365738 192.658157,145.160553 192.660583,132.422714 C192.662613,121.757530 192.612106,111.091972 192.685028,100.427269 C192.754379,90.283310 197.296936,85.712517 207.370483,85.711800 C312.355927,85.704330 417.344086,85.311729 522.324890,86.014297 C549.890869,86.198784 577.409119,89.947281 602.525208,103.154099 C606.795288,105.399452 610.911926,107.936447 615.406616,110.532318 z"/>
            <path fill="#350473" opacity="1.000000" stroke="none" d="M274.955811,603.428650 C265.735260,603.018677 262.657410,599.525208 262.656921,589.853088 C262.651031,469.247589 262.653198,348.642090 262.653503,228.036606 C262.653534,214.210281 262.630890,200.383911 262.664520,186.557663 C262.686218,177.637589 266.533203,173.696289 275.388214,173.657883 C289.547424,173.596451 303.707367,173.598465 317.866516,173.669754 C326.474609,173.713104 330.331329,177.635498 330.332245,186.259338 C330.346436,321.024292 330.348633,455.789246 330.338531,590.554199 C330.337860,599.535339 327.275208,603.337708 318.324158,603.558777 C304.027374,603.911804 289.712006,603.514160 274.955811,603.428650 z"/>
            <path fill="#22014B" opacity="1.000000" stroke="none" d="M591.337769,520.133057 C591.344788,556.408386 591.253906,592.198425 591.451965,627.986816 C591.479675,632.976746 590.168274,634.963013 585.032715,634.449280 C581.077332,634.053589 577.037048,634.168762 573.059021,634.430237 C569.020142,634.695740 567.440979,633.341064 567.558167,629.102905 C567.815796,619.788269 567.649719,610.461304 567.609192,601.139526 C567.600708,599.192261 567.974609,597.120300 566.441345,595.462158 C566.093933,595.519165 565.663452,595.455872 565.474304,595.640137 C554.077026,606.743713 540.436646,606.945679 526.934998,601.799927 C512.817261,596.419434 507.117188,583.918091 504.684784,569.764404 C502.787811,558.726257 503.626282,547.852905 507.647552,537.434509 C517.075012,513.009644 543.294373,505.622528 564.240479,521.289734 C565.148010,521.968567 565.974426,522.904602 567.349121,522.655945 C568.847839,520.872925 568.242981,518.519714 569.101379,515.799561 C575.671875,515.799561 582.413879,515.707031 589.150879,515.849731 C591.504333,515.899536 591.204712,518.024963 591.337769,520.133057 M531.258240,570.195374 C531.722290,571.615723 532.077576,573.083191 532.668701,574.448547 C535.796753,581.673157 542.557922,585.997559 549.992920,585.605164 C557.993774,585.182861 563.900024,580.450684 566.098206,572.253357 C568.474731,563.391052 568.404297,554.477295 565.458069,545.732788 C562.730225,537.636230 557.006958,533.305664 549.296753,533.184509 C541.359863,533.059814 535.202759,537.374695 532.216492,545.289795 C529.238892,553.182068 529.831848,561.275940 531.258240,570.195374 z"/>
            <path fill="#22014B" opacity="1.000000" stroke="none" d="M695.532288,421.265991 C706.227783,416.790863 717.399963,417.380585 728.185242,415.666534 C731.601318,415.123657 735.441040,415.074005 736.541931,410.790161 C737.543274,406.893768 734.932373,402.118530 730.978455,399.992371 C722.221130,395.283264 711.973267,398.488800 707.930420,407.416901 C706.942505,409.598663 705.741089,410.416351 703.444092,410.368073 C698.447998,410.263062 693.436646,410.134369 688.452942,410.407196 C683.685974,410.668182 683.309143,408.159119 683.902771,404.467010 C685.705200,393.257721 692.406738,386.129181 702.872498,382.791992 C714.678223,379.027557 726.795410,378.861603 738.763794,382.188446 C753.949280,386.409515 760.014832,394.638214 760.234131,411.016968 C760.383606,422.178192 760.161865,433.344330 760.311646,444.505524 C760.420105,452.587982 759.102051,460.849030 763.801758,469.261932 C755.899902,469.261932 749.001038,469.285614 742.102478,469.247711 C740.000549,469.236145 739.366089,467.542877 738.900452,465.942749 C738.396240,464.209778 738.137756,462.405273 737.790344,460.720551 C736.032104,460.263245 735.512634,461.582275 734.795715,462.326050 C724.321533,473.192413 711.515015,474.328003 697.893982,470.733093 C687.831421,468.077332 681.516663,460.328857 680.690430,450.919189 C679.367615,435.855011 683.499695,427.451080 695.532288,421.265991 M723.968445,431.486969 C720.437073,432.389557 716.734985,432.536530 713.336182,434.049377 C708.056824,436.399353 705.916931,439.602722 706.249695,444.828186 C706.589783,450.169006 710.050720,452.714478 714.669678,454.087097 C725.053528,457.172882 734.942627,449.627014 736.568970,437.453644 C737.477783,430.650940 736.527039,429.770020 729.799622,430.977112 C728.172485,431.269043 726.494690,431.278320 723.968445,431.486969 z"/>
            <path fill="#6B21FC" opacity="1.000000" stroke="none" d="M452.473236,384.200928 C463.332764,379.614868 474.280121,379.359192 485.117004,381.819916 C500.003082,385.200012 511.563202,398.809906 513.275818,414.013580 C513.720642,417.962921 514.533142,421.862976 514.392517,425.904236 C514.168335,432.345215 514.316833,432.370483 507.609772,432.375488 C491.788696,432.387299 475.967590,432.360474 460.146545,432.386078 C454.132904,432.395813 453.795410,432.946747 455.227356,438.725830 C456.983887,445.814789 461.185394,450.833038 468.317139,452.328186 C475.687561,453.873322 482.158447,451.642059 486.749634,445.259094 C487.629059,444.036438 488.362640,442.708435 490.156586,442.710876 C497.618073,442.720978 505.079529,442.715088 513.088318,442.715088 C511.209198,452.074677 506.629669,458.946381 499.582642,464.121155 C471.567596,484.693237 433.409424,467.892334 429.569733,433.345337 C427.972931,418.978271 430.131622,405.519653 439.478088,393.915741 C442.875519,389.697693 447.204926,386.619385 452.473236,384.200928 M478.448120,416.658844 C480.276001,416.658600 482.104340,416.684875 483.931671,416.653015 C488.889435,416.566589 489.433380,415.787537 487.927826,411.008148 C485.582672,403.563751 478.528168,398.279114 471.158264,398.445923 C463.373138,398.622070 456.925385,403.717682 454.729950,411.386169 C453.757690,414.782135 454.282959,416.823212 458.520660,416.698730 C464.829620,416.513428 471.148224,416.655518 478.448120,416.658844 z"/>
            <path fill="#B593F5" opacity="1.000000" stroke="none" d="M656.309204,584.552368 C658.345276,583.339539 660.716736,582.629456 661.552307,581.087280 C664.832520,575.032837 670.217224,575.347534 675.754700,575.631042 C680.374573,575.867615 685.039307,575.190247 690.280823,576.230957 C688.051636,586.460815 682.505615,594.179016 673.855713,599.090820 C658.921631,607.571167 643.035217,607.970520 627.999512,600.075073 C612.973267,592.184753 606.868347,578.352844 606.589233,561.579651 C606.363037,547.988892 608.607300,535.378540 618.567505,525.262146 C626.173035,517.537354 635.459045,513.887451 646.305847,513.572510 C656.885620,513.265442 666.905823,514.509583 675.490234,521.394409 C688.735229,532.017151 692.044189,546.456787 691.288269,562.468689 C691.129578,565.830200 688.631104,565.309692 686.557434,565.314636 C670.402222,565.352905 654.246826,565.345337 638.091492,565.352661 C630.783447,565.355957 630.524963,565.689575 632.503845,572.548157 C635.648438,583.447266 644.497742,588.025696 656.309204,584.552368 M634.748230,538.320679 C633.861328,540.093079 632.801025,541.801636 632.121277,543.650146 C630.347778,548.472534 631.139343,549.604858 636.213562,549.629822 C644.676758,549.671448 653.141602,549.551147 661.603149,549.676392 C665.410767,549.732727 666.179016,548.206726 665.179749,544.763977 C661.220886,531.124817 645.411682,527.396301 634.748230,538.320679 z"/>
            <path fill="#22014B" opacity="1.000000" stroke="none" d="M604.372559,429.959229 C612.514526,448.159546 604.348450,465.706726 585.541870,470.356750 C572.231506,473.647827 558.793213,473.742737 545.731079,469.090607 C535.416443,465.417023 528.855896,458.202972 526.946350,447.097656 C526.368225,443.735748 527.132568,441.966461 530.840881,442.019806 C536.670288,442.103699 542.501831,442.074005 548.332214,442.045654 C550.575500,442.034760 552.018433,442.833405 552.828979,445.106323 C556.088745,454.247314 568.536804,456.322479 575.809509,453.537598 C579.129333,452.266388 581.894043,450.047363 582.225647,446.510864 C582.570129,442.838074 579.839722,440.446533 576.716187,438.917633 C570.050781,435.654968 562.636108,435.151367 555.554138,433.426208 C550.702087,432.244232 545.848694,431.087708 541.366943,428.823273 C525.215576,420.662567 523.853760,396.379395 539.115601,386.526642 C548.920288,380.197021 560.078430,379.320435 571.310669,380.062378 C577.746277,380.487518 584.133484,381.809418 590.087402,384.668976 C599.785645,389.326843 604.855225,397.525696 604.088318,408.239990 C597.194763,408.239990 590.244385,408.230591 583.294067,408.246063 C581.378540,408.250336 580.989807,406.864899 580.322632,405.451111 C576.609741,397.583801 565.608643,394.428741 558.165771,399.057526 C555.937195,400.443542 554.343323,402.428253 554.483276,405.178253 C554.626343,407.989288 556.610229,409.612640 558.973816,410.695648 C565.087097,413.496826 571.787109,414.079010 578.229553,415.628326 C583.565247,416.911469 588.931763,418.072815 593.897339,420.496155 C598.159729,422.576294 601.837219,425.371307 604.372559,429.959229 z"/>
            <path fill="#22014B" opacity="1.000000" stroke="none" d="M448.403412,533.436462 C442.688354,535.254639 439.380188,539.174805 437.585327,544.211121 C434.068024,554.080139 434.005951,564.150696 437.514099,574.007812 C439.825989,580.503601 444.651123,584.406372 451.798584,584.608337 C458.812958,584.806580 464.118683,581.855530 466.722076,575.160706 C467.831451,572.307861 469.552277,571.534485 472.382294,571.597778 C478.827423,571.742065 485.277954,571.643311 492.210022,571.643311 C491.396118,582.447083 487.010620,590.480408 479.448151,596.828979 C465.078400,608.892395 429.355103,609.265991 415.906586,586.012390 C405.354828,567.767639 406.409790,532.657593 427.934814,519.962646 C443.565552,510.744110 459.890869,510.511810 475.994476,518.756714 C484.789062,523.259460 489.648987,531.134949 491.921661,540.679016 C492.673737,543.837463 491.942200,545.447327 488.400635,545.384399 C482.406403,545.277832 476.407501,545.272766 470.413635,545.386902 C468.023407,545.432495 466.968475,544.336548 466.006927,542.274414 C462.257477,534.233765 457.574097,531.906250 448.403412,533.436462 z"/>
            <path fill="#22014B" opacity="1.000000" stroke="none" d="M627.503723,401.788391 C625.973145,400.018677 624.188354,400.217194 622.606323,400.420746 C617.592712,401.065918 616.028320,398.733154 616.622620,394.110931 C616.812195,392.636536 616.627136,391.116730 616.656677,389.618530 C616.781921,383.260712 615.329773,381.755066 623.870422,381.958099 C626.896301,382.030029 628.008911,380.533630 627.957703,377.661926 C627.883423,373.500336 628.044128,369.333862 627.938110,365.173706 C627.860535,362.129425 628.826965,360.524963 632.202332,360.620880 C637.859802,360.781494 643.528870,360.790741 649.185547,360.617523 C652.600098,360.512970 653.479614,362.128540 653.373352,365.173370 C653.233887,369.165039 653.491699,373.172211 653.307861,377.160217 C653.154541,380.486877 654.237305,381.940704 657.795959,382.056335 C661.487427,382.176300 666.641663,380.104370 668.557983,383.503601 C670.832642,387.538788 669.234436,392.933807 669.239014,397.740509 C669.240479,399.328003 668.376343,400.192932 666.769592,400.258667 C665.771851,400.299500 664.773682,400.340820 663.775391,400.350708 C652.090271,400.466492 653.419495,398.929565 653.358887,410.720276 C653.310059,420.212219 653.341187,429.704620 653.350891,439.196838 C653.361450,449.551361 655.237732,451.472107 665.437439,451.647552 C666.428589,451.664612 667.418457,451.758850 669.258484,451.867401 C669.258484,456.965424 669.298767,462.041748 669.239380,467.116943 C669.214111,469.273621 667.498352,469.940643 665.817871,470.045837 C658.844238,470.482361 651.773254,471.196106 644.906128,469.882172 C634.604004,467.910919 629.343872,460.779816 628.600159,450.087830 C627.639404,436.276581 628.137146,422.462433 627.940735,408.650604 C627.910034,406.490845 627.775513,404.332581 627.503723,401.788391 z"/>
            <path fill="#22014B" opacity="1.000000" stroke="none" d="M706.812012,532.002930 C707.265137,526.431580 704.602478,519.952881 708.160889,516.639954 C711.420044,513.605591 717.724976,515.921326 722.677795,515.639343 C723.507202,515.592102 724.352478,515.721680 725.172119,515.620911 C729.597351,515.076965 731.768372,516.675110 731.156555,521.431091 C730.883911,523.550476 731.110474,525.734192 731.110474,529.079712 C734.531799,524.630859 737.105896,520.817810 741.243042,518.665466 C742.567444,517.976501 743.844910,517.181152 745.212097,516.593323 C756.976990,511.534729 759.348816,513.024353 759.347656,525.413086 C759.347595,525.745972 759.347595,526.078796 759.347595,526.411682 C759.346863,536.625244 759.346802,536.625305 749.135132,537.374756 C739.456421,538.085022 732.501648,545.205017 732.364990,555.080994 C732.173889,568.891785 732.131897,582.710022 732.384583,596.518494 C732.470276,601.203247 731.142456,603.274536 726.245911,602.951904 C721.771484,602.657104 717.255310,602.717651 712.771423,602.924622 C708.364258,603.128052 706.671875,601.622009 706.721924,596.909363 C706.949890,575.442383 706.816284,553.971558 706.812012,532.002930 z"/>
            <path fill="#22014B" opacity="1.000000" stroke="none" d="M391.439575,383.334900 C394.903778,386.003754 391.996613,389.989258 394.028870,392.667328 C395.090790,393.224579 395.774536,392.688690 396.286469,392.038177 C401.542358,385.359344 408.577545,382.276672 416.864899,381.170807 C420.195953,380.726318 421.506836,381.227234 421.419678,384.756805 C421.264465,391.042053 421.376038,397.333862 421.376038,403.549866 C418.382477,404.858551 415.702118,404.070862 413.104065,404.161224 C401.868042,404.552002 394.476257,411.911316 394.379791,423.264862 C394.262421,437.081940 394.229187,450.902374 394.419250,464.717773 C394.475220,468.786621 393.244049,470.458832 389.033295,470.196503 C384.389648,469.907135 379.705658,469.947388 375.055542,470.175537 C370.974335,470.375763 369.550201,468.857819 369.578522,464.704926 C369.733795,441.897858 369.651215,419.089203 369.650513,396.281067 C369.650085,382.959503 369.650269,382.949493 383.037109,382.989166 C385.697479,382.997040 388.357544,383.113892 391.439575,383.334900 z"/>
            <path fill="#22014B" opacity="1.000000" stroke="none" d="M394.353394,543.000122 C394.351990,561.466980 394.216431,579.435486 394.442596,597.399475 C394.499207,601.894958 392.887604,603.263794 388.661835,603.040405 C383.850586,602.785950 379.015442,602.918823 374.191986,602.983032 C371.207581,603.022705 369.607941,602.089844 369.618683,598.697571 C369.702087,572.413025 369.702484,546.127991 369.617340,519.843506 C369.606445,516.491455 371.041992,515.518860 374.120728,515.594910 C379.440948,515.726379 384.770416,515.750549 390.088898,515.587891 C393.388214,515.487061 394.429810,516.899414 394.375122,520.042297 C394.244812,527.526062 394.345673,535.013855 394.353394,543.000122 z"/>
            <path fill="#22014B" opacity="1.000000" stroke="none" d="M381.066406,485.633850 C394.354584,485.655762 394.354584,485.655762 394.348328,498.479889 C394.344482,506.375275 394.344482,506.374573 386.559540,506.377380 C382.396912,506.378845 378.230164,506.270325 374.073029,506.423126 C370.922668,506.538910 369.516968,505.400543 369.616486,502.110107 C369.776123,496.831268 369.659271,491.544067 369.659271,485.634094 C373.683289,485.634094 377.132050,485.634094 381.066406,485.633850              z"/>
        </svg>
        <span style="color: #2C0161">{l s='PrestaPicqer Configuration' mod='prestapicqer'}<span>
        <a class="alert alert-info pull-right help_button" href="https://softerbv.nl/prestapicqer/docs/?lang={$lang_iso}" target="_BLANK">
            {l s='Help' mod='prestapicqer'}
        </a>
    </div>

    <ul class="nav nav-tabs">
        <li class="active"><a href="#general_settings_tab" data-toggle="tab">{l s='General Settings' mod='prestapicqer'}</a></li>
        <li><a href="#order_settings_tab" data-toggle="tab">{l s='Orders' mod='prestapicqer'}</a></li>
        <li><a href="#stock_settings_tab" data-toggle="tab">{l s='Stock' mod='prestapicqer'}</a></li>
    </ul>

    <div class="tab-content">
        <div class="tab-pane active" id="general_settings_tab">
            <form action="{$current_index|escape:'htmlall':'UTF-8'}&amp;configure={$module_name|escape:'htmlall':'UTF-8'}&amp;token={$token|escape:'htmlall':'UTF-8'}" method="post" id="form_general_settings" class="defaultForm form-horizontal">
                <div class="panel-body">
                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Picqer Subdomain' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <input type="text" name="PRESTAPICQER_API_SUBDOMAIN" value="{$picqer_api_subdomain|escape:'htmlall':'UTF-8'}" class="form-control" required />
                            <p class="help-block">{l s='Your Picqer subdomain (e.g., "yourcompany" if your Picqer URL is yourcompany.picqer.com).' mod='prestapicqer'}</p>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Picqer API Key' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <div class="apiKeyContainer">
                                <input type="text" name="PRESTAPICQER_API_KEY" value="{$picqer_api_key|escape:'htmlall':'UTF-8'}" class="form-control" required id="picqerApiKey" />
                                <div class="big_label" id="togglePassword" tabindex="0">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" fill="currentColor" viewBox="0 0 28 28" class="showKey">
                                        <path d="M14 17a3 3 0 1 0 0-6 3 3 0 0 0 0 6Z M26 14c0-1.6-4.8-8-12-8S2 12.4 2 14c0 1.6 4.8 8 12 8s12-6.4 12-8Zm-6.5 0a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0Z" clip-rule="evenodd"/>
                                    </svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" fill="none" viewBox="0 0 28 28" class="hideKey">
                                        <path fill="currentColor" fill-rule="evenodd" d="M7.2801 4.3661c-.4881-.4881-1.2796-.4881-1.7677 0-.4882.4882-.4882 1.2796 0 1.7678l1.677 1.677c-2.3166 1.3213-4.1752 3.2997-5.0804 5.7137-.0566.151-.0849.2265-.1003.333a1.1697 1.1697 0 0 0 0 .2848c.0154.1065.0437.182.1003.333C3.8072 19.0045 8.8614 22 14 22c2.0855 0 4.157-.4934 5.996-1.3825l2.0164 2.0164c.4881.4881 1.2796.4881 1.7677 0 .4882-.4882.4882-1.2796 0-1.7678l-16.5-16.5Zm10.6392 14.1747-2.1328-2.1328a2.987 2.987 0 0 1-1.7863.5896c-1.6569 0-3-1.3432-3-3a2.987 2.987 0 0 1 .5895-1.7864l-2.1328-2.1328c-.9078 1.0514-1.4567 2.4212-1.4567 3.9192 0 3.3137 2.6863 6 6 6 1.498 0 2.8678-.549 3.9191-1.4568Z M14.4618 8.015c2.9457.2242 5.2967 2.5753 5.5209 5.5209l4.0423 4.0423c.7996-.9218 1.4389-1.9638 1.866-3.1028.0566-.151.0849-.2265.1003-.333a1.1697 1.1697 0 0 0 0-.2848c-.0154-.1065-.0437-.182-.1003-.333C24.1928 8.9956 19.1386 6 14 6c-.4924 0-.984.0275-1.472.0812l1.9338 1.9339Z"/>
                                    </svg>
                                </div>
                            </div>
                            <a href="https://redirect.picqer.com/config/apikeys" target="_BLANK">
                                <p class="help-block">{l s='Your Picqer API key. Generate one in Picqer under Settings > API Keys. Click here to go directly to Picqer.' mod='prestapicqer'}</p>
                            </a>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Shop Identifier Prefix' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <input type="text" name="PRESTAPICQER_SHOP_IDENTIFIER" value="{$shop_identifier|escape:'htmlall':'UTF-8'}" class="form-control" maxlength="3" required />
                            <p class="help-block">{l s='A 1-3 character alphanumeric prefix for order numbers that is unique for this shop (e.g., "PS", "WEB"). In Picqer "Prefix #PsOrderId / PsOrderReference" will be added to the order reference field.' mod='prestapicqer'}</p>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Webhook URL' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <p class="form-control-static no-bottom-padding">
                                <code>{$webhook_url|escape:'htmlall':'UTF-8'}</code>
                            </p>
                            <p class="help-block">{l s='This is the URL Picqer will send webhooks to. Ensure it is accessible from the internet.' mod='prestapicqer'}</p>
                        </div>
                    </div>
                </div>
                <div class="panel-footer">
                    <button type="submit" name="submitPrestaPicqerGeneral" class="btn btn-default pull-right">
                        <i class="process-icon-save"></i> {l s='Save' mod='prestapicqer'}
                    </button>
                </div>
            </form>
        </div>

        <div class="tab-pane" id="order_settings_tab">
            <form action="{$current_index|escape:'htmlall':'UTF-8'}&amp;configure={$module_name|escape:'htmlall':'UTF-8'}&amp;token={$token|escape:'htmlall':'UTF-8'}" method="post" id="form_order_settings" class="defaultForm form-horizontal">
                <div class="panel-body">

                    <h3 class="no_margin">{l s='PrestaShop to Picqer' mod='prestapicqer'}</h3>
                    <br/>
                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Enable order synchronization' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <span class="switch prestashop-switch fixed-width-lg">
                                <input type="radio" name="PRESTAPICQER_ORDER_SYNC_ENABLED" id="PRESTAPICQER_ORDER_SYNC_ENABLED_on" value="1" {if $order_sync_enabled}checked="checked"{/if}>
                                <label for="PRESTAPICQER_ORDER_SYNC_ENABLED_on">{l s='Yes' mod='prestapicqer'}</label>
                                <input type="radio" name="PRESTAPICQER_ORDER_SYNC_ENABLED" id="PRESTAPICQER_ORDER_SYNC_ENABLED_off" value="0" {if !$order_sync_enabled}checked="checked"{/if}>
                                <label for="PRESTAPICQER_ORDER_SYNC_ENABLED_off">{l s='No' mod='prestapicqer'}</label>
                                <a class="slide-button btn"></a>
                            </span>
                            <p class="help-block">{l s='Enable this to automatically create and update PrestaShop orders in Picqer.' mod='prestapicqer'}</p>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Create customers in Picqer' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <span class="switch prestashop-switch fixed-width-lg">
                                <input type="radio" name="PRESTAPICQER_CREATE_CUSTOMERS_ENABLED" id="PRESTAPICQER_CREATE_CUSTOMERS_ENABLED_on" value="1" {if $create_customers_enabled}checked="checked"{/if}>
                                <label for="PRESTAPICQER_CREATE_CUSTOMERS_ENABLED_on">{l s='Yes' mod='prestapicqer'}</label>
                                <input type="radio" name="PRESTAPICQER_CREATE_CUSTOMERS_ENABLED" id="PRESTAPICQER_CREATE_CUSTOMERS_ENABLED_off" value="0" {if !$create_customers_enabled}checked="checked"{/if}>
                                <label for="PRESTAPICQER_CREATE_CUSTOMERS_ENABLED_off">{l s='No' mod='prestapicqer'}</label>
                                <a class="slide-button btn"></a>
                            </span>
                            <p class="help-block">{l s='If enabled, customers will be created in Picqer when orders are exported. Existing customers are identified by email address. Both billing and shipping addresses will be added to the Picqer customer profile.' mod='prestapicqer'}</p>
                        </div>
                    </div>
                   
                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Apply tags to new orders' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <select name="PRESTAPICQER_ORDER_TAGS[]" id="picqer_order_tags_select" class="form-control chosen picqer-tag-selector" multiple>
                                {foreach from=$picqer_tags item=tag}
                                    <option value="{$tag.idtag|intval}"
                                            data-bgcolor="{$tag.color|escape:'htmlall':'UTF-8'}"
                                            {if in_array($tag.idtag, $order_tags_selected)}selected{/if}>
                                        {$tag.title|escape:'htmlall':'UTF-8'}
                                    </option>
                                {/foreach}
                            </select>
                            <p class="help-block">{l s='Select tags to automatically apply to new orders when exported to Picqer.' mod='prestapicqer'}</p>
                        </div>
                    </div>
                   
                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Use PrestaShop product price' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <span class="switch prestashop-switch fixed-width-lg">
                                <input type="radio" name="PRESTAPICQER_USE_PS_PRODUCT_PRICE" id="PRESTAPICQER_USE_PS_PRODUCT_PRICE_on" value="1" {if $use_ps_product_price}checked="checked"{/if}>
                                <label for="PRESTAPICQER_USE_PS_PRODUCT_PRICE_on">{l s='Yes' mod='prestapicqer'}</label>
                                <input type="radio" name="PRESTAPICQER_USE_PS_PRODUCT_PRICE" id="PRESTAPICQER_USE_PS_PRODUCT_PRICE_off" value="0" {if !$use_ps_product_price}checked="checked"{/if}>
                                <label for="PRESTAPICQER_USE_PS_PRODUCT_PRICE_off">{l s='No' mod='prestapicqer'}</label>
                                <a class="slide-button btn"></a>
                            </span>
                            <p class="help-block">{l s='If enabled, product prices from PrestaShop will be sent to Picqer. If disabled, Picqer will use its own product prices.' mod='prestapicqer'}</p>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Create missing products' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <span class="switch prestashop-switch fixed-width-lg">
                                <input type="radio" name="PRESTAPICQER_CREATE_MISSING_PRODUCTS" id="PRESTAPICQER_CREATE_MISSING_PRODUCTS_on" value="1" {if $create_missing_products}checked="checked"{/if}>
                                <label for="PRESTAPICQER_CREATE_MISSING_PRODUCTS_on">{l s='Yes' mod='prestapicqer'}</label>
                                <input type="radio" name="PRESTAPICQER_CREATE_MISSING_PRODUCTS" id="PRESTAPICQER_CREATE_MISSING_PRODUCTS_off" value="0" {if !$create_missing_products}checked="checked"{/if}>
                                <label for="PRESTAPICQER_CREATE_MISSING_PRODUCTS_off">{l s='No' mod='prestapicqer'}</label>
                                <a class="slide-button btn"></a>
                            </span>
                            <p class="help-block">{l s='If enabled, products that are missing in Picqer will be automatically created.' mod='prestapicqer'}</p>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Create new order in Picqer' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <select name="PRESTAPICQER_ORDER_CREATE_STATUSES[]" class="form-control chosen" multiple>
                                {foreach from=$ps_order_statuses item=status}
                                    <option value="{$status.id_order_state|intval}" {if in_array($status.id_order_state, $order_create_statuses)}selected{/if}>{$status.name|escape:'htmlall':'UTF-8'}</option>
                                {/foreach}
                            </select>
                            <p class="help-block">{l s='Orders with these statuses will be created in Picqer as "concept" orders.' mod='prestapicqer'}</p>
                        </div>
                    </div>

                   
                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Allocate stock for "Concept" orders' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <span class="switch prestashop-switch fixed-width-lg">
                                <input type="radio" name="PRESTAPICQER_ALLOCATE_STOCK" id="PRESTAPICQER_ALLOCATE_STOCK_on" value="1" {if $allocate_stock}checked="checked"{/if}>
                                <label for="PRESTAPICQER_ALLOCATE_STOCK_on">{l s='Yes' mod='prestapicqer'}</label>
                                <input type="radio" name="PRESTAPICQER_ALLOCATE_STOCK" id="PRESTAPICQER_ALLOCATE_STOCK_off" value="0" {if !$allocate_stock}checked="checked"{/if}>
                                <label for="PRESTAPICQER_ALLOCATE_STOCK_off">{l s='No' mod='prestapicqer'}</label>
                                <a class="slide-button btn"></a>
                            </span>
                            <p class="help-block">{l s='If enabled, stock will be allocated in Picqer for orders with status "Concept".' mod='prestapicqer'}</p>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Change Picqer order status to "Processing"' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <select name="PRESTAPICQER_ORDER_PROCESS_STATUSES[]" class="form-control chosen" multiple>
                                {foreach from=$ps_order_statuses item=status}
                                    <option value="{$status.id_order_state|intval}" {if in_array($status.id_order_state, $order_process_statuses)}selected{/if}>{$status.name|escape:'htmlall':'UTF-8'}</option>
                                {/foreach}
                            </select>
                            <p class="help-block">{l s='When an order changes to one of these statuses in PrestaShop, its status will be updated to "Processing" in Picqer.' mod='prestapicqer'}</p>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Change Picqer order status to "Cancelled"' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <select name="PRESTAPICQER_ORDER_CANCEL_STATUSES[]" class="form-control chosen" multiple>
                                {foreach from=$ps_order_statuses item=status}
                                    <option value="{$status.id_order_state|intval}" {if in_array($status.id_order_state, $order_cancel_statuses)}selected{/if}>{$status.name|escape:'htmlall':'UTF-8'}</option>
                                {/foreach}
                            </select>
                            <p class="help-block">{l s='When an order changes to one of these statuses in PrestaShop, its status will be updated to "Cancelled" in Picqer.' mod='prestapicqer'}</p>
                        </div>
                    </div>

                    <h3 class="no_margin">{l s='Picqer to PrestaShop' mod='prestapicqer'}</h3>
                    <br/>
                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Enable order status updates' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <span class="switch prestashop-switch fixed-width-lg">
                                <input type="radio" name="PRESTAPICQER_PULL_ORDER_STATUS_ENABLED" id="PRESTAPICQER_PULL_ORDER_STATUS_ENABLED_on" value="1" {if $pull_order_status_enabled}checked="checked"{/if}>
                                <label for="PRESTAPICQER_PULL_ORDER_STATUS_ENABLED_on">{l s='Yes' mod='prestapicqer'}</label>
                                <input type="radio" name="PRESTAPICQER_PULL_ORDER_STATUS_ENABLED" id="PRESTAPICQER_PULL_ORDER_STATUS_ENABLED_off" value="0" {if !$pull_order_status_enabled}checked="checked"{/if}>
                                <label for="PRESTAPICQER_PULL_ORDER_STATUS_OFF">{l s='No' mod='prestapicqer'}</label>
                                <a class="slide-button btn"></a>
                            </span>
                            <p class="help-block">{l s='Enable this to allow Picqer to update order statuses in PrestaShop via a webhook.' mod='prestapicqer'}</p>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Picqer orders Webhook status' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <div class="webhooks">
                                {if $order_status_webhook_id > 0}
                                    <div class="big_label">
                                        <div class="tagcolor label-success"> </div>
                                        <div> {l s='Active' mod='prestapicqer'} (ID: {$order_status_webhook_id|escape:'htmlall':'UTF-8'})</div>
                                    </div>
                                    <button type="submit" name="deleteOrderStatusWebhook" class="btn btn-danger">{l s='Deactivate Webhook' mod='prestapicqer'}</button>
                                {else}
                                    <div class="big_label">
                                        <div class="tagcolor label-danger"> </div>
                                        <div> {l s='Inactive' mod='prestapicqer'} </div>
                                    </div>

                                    <div id="orderStatusWebhookWarning" {if !$pull_order_status_enabled}class="hide"{/if} title="{l s='Order updates need an active webhook to work.' mod='prestapicqer'}">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 20 20" fill="currentColor" style="vertical-align: middle; color: #ff3636;">
                                            <path d="M19.64 16.36 11.53 2.3A1.85 1.85 0 0 0 10 1.21 1.85 1.85 0 0 0 8.48 2.3L.36 16.36C-.48 17.81.21 19 1.88 19h16.24c1.67 0 2.36-1.19 1.52-2.64zM11 16H9v-2h2zm0-4H9V6h2z"/>
                                        </svg>
                                    </div>
                                   
                                    <button type="submit" name="createOrderStatusWebhook" class="btn btn-success">{l s='Create Webhook' mod='prestapicqer'}</button>
                                {/if}
                            </div>
                            <p class="help-block">{l s='This webhook updates order statuses in PrestaShop when order statuses change in Picqer. Statuses will be updated according to the order status mapping table below.' mod='prestapicqer'}<br>{l s='"From PrestaShop Status" allows you to specify a PrestaShop status that must be active for the mapping to apply. Select "Any" to apply the mapping regardless of the current PrestaShop status.' mod='prestapicqer'}</p>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Order status mapping' mod='prestapicqer'}</label>
                        <div id="order_status_mapping_section">
                            <div class="table-responsive col-lg-9">
                                <table class="table" id="status_mapping_table">
                                    <thead>
                                        <tr>
                                            <th>{l s='From PrestaShop Status' mod='prestapicqer'}</th>
                                            <th>{l s='Picqer Status' mod='prestapicqer'}</th>
                                            <th>{l s='To PrestaShop Status' mod='prestapicqer'}</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {* Render existing mappings if they exist *}
                                        {if !empty($status_mappings)}
                                            {foreach from=$status_mappings item=mapping}
                                                <tr>
                                                    <td>
                                                        <select name="ps_from_status_id[]" class="form-control">
                                                            <option value="0" {if $mapping.ps_from_status_id == 0}selected{/if}>{l s='Any' mod='prestapicqer'}</option>
                                                            {foreach from=$ps_order_statuses item=status}
                                                                <option value="{$status.id_order_state|intval}" {if $mapping.ps_from_status_id == $status.id_order_state}selected{/if}>{$status.name|escape:'htmlall':'UTF-8'}</option>
                                                            {/foreach}
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <select name="picqer_status_name[]" class="form-control" required>
                                                            <option value="">{l s='-- Choose --' mod='prestapicqer'}</option>
                                                            {foreach from=$picqer_statuses item=picqer_status}
                                                                <option value="{$picqer_status|escape:'htmlall':'UTF-8'}" {if $mapping.picqer_status_name == $picqer_status}selected{/if}>{$picqer_statuses_translated[$picqer_status]|escape:'htmlall':'UTF-8'}</option>
                                                            {/foreach}
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <select name="ps_to_status_id[]" class="form-control" required>
                                                            <option value="">{l s='-- Choose --' mod='prestapicqer'}</option>
                                                            {foreach from=$ps_order_statuses item=status}
                                                                <option value="{$status.id_order_state|intval}" {if $mapping.ps_to_status_id == $status.id_order_state}selected{/if}>{$status.name|escape:'htmlall':'UTF-8'}</option>
                                                            {/foreach}
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-danger remove-row" title="{l s='Remove' mod='prestapicqer'}">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                                <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z"/>
                                                                <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z"/>
                                                            </svg>
                                                        </button>
                                                    </td>
                                                </tr>
                                            {/foreach}
                                        {else if empty($status_mappings) && $pull_order_status_enabled}
                                            <tr>
                                                <td>
                                                    <select name="ps_from_status_id[]" class="form-control">
                                                        <option value="0">{l s='Any' mod='prestapicqer'}</option>
                                                        {foreach from=$ps_order_statuses item=status}
                                                            <option value="{$status.id_order_state|intval}">{$status.name|escape:'htmlall':'UTF-8'}</option>
                                                        {/foreach}
                                                    </select>
                                                </td>
                                                <td>
                                                    <select name="picqer_status_name[]" class="form-control" required>
                                                        <option value="">{l s='-- Choose --' mod='prestapicqer'}</option>
                                                        {foreach from=$picqer_statuses item=picqer_status}
                                                            <option value="{$picqer_status|escape:'htmlall':'UTF-8'}">{$picqer_statuses_translated[$picqer_status]|escape:'htmlall':'UTF-8'}</option>
                                                        {/foreach}
                                                    </select>
                                                </td>
                                                <td>
                                                    <select name="ps_to_status_id[]" class="form-control" required>
                                                        <option value="">{l s='-- Choose --' mod='prestapicqer'}</option>
                                                        {foreach from=$ps_order_statuses item=status}
                                                            <option value="{$status.id_order_state|intval}">{$status.name|escape:'htmlall':'UTF-8'}</option>
                                                        {/foreach}
                                                    </select>
                                                </td>
                                                <td>
                                                    <button type="button" class="btn btn-danger remove-row" title="{l s='Remove' mod='prestapicqer'}">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                            <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z"/>
                                                            <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z"/>
                                                        </svg>
                                                    </button>
                                                </td>
                                            </tr>
                                        {/if}
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="3" class="text-center">
                                                <button type="button" class="btn btn-info" id="add_mapping_row">{l s='Add new mapping' mod='prestapicqer'}</button>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="panel-footer">
                    <button type="submit" name="submitPrestaPicqerOrders" class="btn btn-default pull-right">
                        <i class="process-icon-save"></i> {l s='Save' mod='prestapicqer'}
                    </button>
                </div>
            </form>
        </div>

        <div class="tab-pane" id="stock_settings_tab">
            <form action="{$current_index|escape:'htmlall':'UTF-8'}&amp;configure={$module_name|escape:'htmlall':'UTF-8'}&amp;token={$token|escape:'htmlall':'UTF-8'}" method="post" id="form_stock_settings" class="defaultForm form-horizontal">
                <div class="panel-body">
                    <h3 class="no_margin">{l s='Picqer to PrestaShop Stock Updates' mod='prestapicqer'}</h3>
                    <br>
                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Enable product stock updates' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <span class="switch prestashop-switch fixed-width-lg">
                                <input type="radio" name="PRESTAPICQER_PULL_STOCK_ENABLED" id="PRESTAPICQER_PULL_STOCK_ENABLED_on" value="1" {if $pull_stock_enabled}checked="checked"{/if}>
                                <label for="PRESTAPICQER_PULL_STOCK_ENABLED_on">{l s='Yes' mod='prestapicqer'}</label>
                                <input type="radio" name="PRESTAPICQER_PULL_STOCK_ENABLED" id="PRESTAPICQER_PULL_STOCK_ENABLED_off" value="0" {if !$pull_stock_enabled}checked="checked"{/if}>
                                <label for="PRESTAPICQER_PULL_STOCK_ENABLED_off">{l s='No' mod='prestapicqer'}</label>
                                <a class="slide-button btn"></a>
                            </span>
                            <p class="help-block">{l s='Enable this to allow Picqer to update product stock in PrestaShop via a webhook.' mod='prestapicqer'}</p>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Full catalogue stock sync on Webhook' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <span class="switch prestashop-switch fixed-width-lg">
                                <input type="radio" name="PRESTAPICQER_PULL_STOCK_FULL_SYNC" id="PRESTAPICQER_PULL_STOCK_FULL_SYNC_on" value="1" {if $pull_stock_full_sync}checked="checked"{/if}>
                                <label for="PRESTAPICQER_PULL_STOCK_FULL_SYNC_on">{l s='Yes' mod='prestapicqer'}</label>
                                <input type="radio" name="PRESTAPICQER_PULL_STOCK_FULL_SYNC" id="PRESTAPICQER_PULL_STOCK_FULL_SYNC_off" value="0" {if !$pull_stock_full_sync}checked="checked"{/if}>
                                <label for="PRESTAPICQER_PULL_STOCK_FULL_SYNC_off">{l s='No' mod='prestapicqer'}</label>
                                <a class="slide-button btn"></a>
                            </span>
                            <p class="help-block">{l s='If enabled, a single stock change webhook from Picqer will trigger a full stock synchronization for your entire catalogue. This can be resource-intensive for large catalogues. If disabled, only the specific product in the webhook will be updated.' mod='prestapicqer'}</p>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Full stock sync URL' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <p class="form-control-static no-bottom-padding">
                                <code tabindex="0">{$stock_sync_url|escape:'htmlall':'UTF-8'}</code>
                                <button type="button" class="btn btn-clipboard btn-absolute margin-left" title="{l s='Copy to clipboard' mod='prestapicqer'}" onclick="copyToClipboard(this)">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M4 1.5H3a2 2 0 0 0-2 2V14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3.5a2 2 0 0 0-2-2h-1v1h1a1 1 0 0 1 1 1V14a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3.5a1 1 0 0 1 1-1h1z"></path>
                                        <path d="M9.5 1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .5-.5zm-3-1A1.5 1.5 0 0 0 5 1.5v1A1.5 1.5 0 0 0 6.5 4h3A1.5 1.5 0 0 0 11 2.5v-1A1.5 1.5 0 0 0 9.5 0z"></path>
                                    </svg>
                                </button>
                            </p>
                            <p class="help-block">{l s='Optionally you can trigger a full stock synchronisation by calling this URL.' mod='prestapicqer'}</p>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-lg-3">{l s='Picqer stock Webhook status' mod='prestapicqer'}</label>
                        <div class="col-lg-9">
                            <div class="webhooks">
                                {if $stock_webhook_id > 0 && $assembled_stock_webhook_id > 0}
                                    <div class="big_label">
                                        <div class="tagcolor label-success"> </div>
                                        <div>{l s='Active' mod='prestapicqer'} (Free: {$stock_webhook_id|escape:'htmlall':'UTF-8'}, Assembled: {$assembled_stock_webhook_id|escape:'htmlall':'UTF-8'})</div>
                                    </div>
                                    <button type="submit" name="deleteStockWebhooks" class="btn btn-danger">{l s='Deactivate Webhooks' mod='prestapicqer'}</button>
                                {else}
                                    <div class="big_label">
                                        <div class="tagcolor label-danger"> </div>
                                        <div>{l s='Inactive' mod='prestapicqer'}</div>
                                    </div>

                                    <div id="stockChangeWebhookWarning" {if !$pull_stock_enabled}class="hide"{/if} title="{l s='Stock updates need active webhooks to work.' mod='prestapicqer'}">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 20 20" fill="currentColor" style="vertical-align: middle; color: #ff3636;">
                                            <path d="M19.64 16.36 11.53 2.3A1.85 1.85 0 0 0 10 1.21 1.85 1.85 0 0 0 8.48 2.3L.36 16.36C-.48 17.81.21 19 1.88 19h16.24c1.67 0 2.36-1.19 1.52-2.64zM11 16H9v-2h2zm0-4H9V6h2z"/>
                                        </svg>
                                    </div>

                                    <button type="submit" name="createStockWebhooks" class="btn btn-success">{l s='Create Webhooks' mod='prestapicqer'}</button>
                                {/if}
                            </div>
                            <p class="help-block">{l s='These webhooks update product stock in PrestaShop when changed in Picqer (both regular and virtual assembled products).' mod='prestapicqer'}</p>
                        </div>
                    </div>
                </div>
                
                <div class="panel-footer">
                    <button type="submit" name="submitPrestaPicqerStock" class="btn btn-default pull-right">
                        <i class="process-icon-save"></i> {l s='Save' mod='prestapicqer'}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">

    const copyToClipboard = async (el) => {
        try {
            const element = el.previousElementSibling;
            await navigator.clipboard.writeText(element.textContent);
        } catch (error) {
            console.error("Failed to copy to clipboard:", error);
        }
    }

    $(document).ready(function() {
        $('.chosen').chosen({
            width: "100%",
            no_results_text: "{l s='No results matched' mod='prestapicqer' js=1}"
        });

        $('head').append(`
            <style type="text/css">
                .tagcolor{
                    border-radius: 25px;
                    width: 14px;
                    height: 14px;
                    background-image: none !important;
                    box-shadow: none !important;
                    text-shadow: none !important;
                }
                .chosen-container .chosen-choices .search-choice,
                .chosen-container .chosen-results li.active-result {
                    background-image: none !important;
                    box-shadow: none !important;
                    text-shadow: none !important;

                    display: flex;
                    gap: 6px;
                    align-items: center;
                }
                .chosen-container .chosen-choices .search-choice {
                    border-radius: 3px;
                    padding: 3px 20px 3px 5px;
                    line-height: 1.5;
                }
                .chosen-container .chosen-choices .search-choice .search-choice-close {
                    top: 50%;
                    margin-top: -4px;
                }

                .chosen-container ul.chosen-choices{
                    border: 1px solid #bbcdd2;
                    border-radius: 4px;
                    box-shadow: none;
                    padding-top: 1px;
                    padding-bottom: 1px;
                }

                #status_mapping_table thead tr th,
                #status_mapping_table tbody tr td,
                #status_mapping_table tfoot tr td{
                    border: none;
                }
                #main #content.bootstrap .no_margin {
                    margin: 0;
                }

                .form-group .webhooks{
                    display: flex;
                    align-items: center;
                    gap: 20px;
                }
 
                .form-group .big_label{
                    border: 1px solid #bbcdd2;
                    padding: 8px 16px;
                    font-size: 12px;
                    line-height: 1.428571429;
                    border-radius: 4px;

                    display: flex;
                    gap: 10px;
                    align-items: center;
                }

                .apiKeyContainer{
                    display: flex;
                    gap: 10px;
                    cursor: pointer;
                }
                #togglePassword{
                    padding: 5px;
                }
                .apiKeyContainer:has(input[type="password"]) .showKey{
                    display: block;
                }

                .apiKeyContainer:has(input[type="text"]) .showKey{
                    display: none;
                }

                .apiKeyContainer:has(input[type="password"]) .hideKey{
                    display: none;
                }

                .apiKeyContainer:has(input[type="text"]) .hideKey{
                    display: block;
                }

                #togglePassword,
                .form-group .btn-clipboard{
                    transition: 0.2s;
                    background-color: #beeaf3;
                    border: solid 1px #25b9d7;
                    background-color: #25b9d7;
                    color: #fff;
                    line-height: 1;
                }
                
                .form-group .btn-clipboard:active,
                .form-group .btn-clipboard:active:focus,
                .form-group .btn-clipboard:focus-visible,
                .form-group .btn-clipboard:focus{
                    outline: none;
                    color: #fff;
                }
                .form-group .btn-clipboard:active:focus{
                    background-color: #beeaf3;
                }
                #togglePassword:hover,
                .form-group .btn-clipboard:hover{
                    color: #fff;
                    background: #7cd5e7;
                    border-color: #7cd5e7;
                }

                .bootstrap .alert.alert-info.help_button{
                    line-height: 0.9px;
                    margin-top: 6px;
                    border-radius: 4px;
                    padding: 20px 20px 20px 46px;
                }
                .bootstrap .alert.alert-info.help_button::before {
                    top: 8px;
                    left: 8px;
                }
                .margin-left{
                    margin-left: 20px;
                }
                .btn-absolute{
                    position: absolute;
                    top: 0px;
                }
                .bootstrap .form-horizontal .form-control-static.no-bottom-padding{
                    padding-bottom: 0;
                }

                .btn.remove-row{
                    height: 40px;
                    width: 40px;
                    line-height: 1;
                    padding: 0;
                }

                #status_mapping_table thead tr th:first-child,
                #status_mapping_table tbody tr td:first-child{
                    padding-left: 0;
                }

                #content.bootstrap .help-block{
                    user-select: none;
                }

                #content.bootstrap select{
                    padding-left: 5px;
                }
                .panel-heading{
                    min-height: 60px;
                }
                .help_button::before{
                    font-size: inherit;
                }

            </style>
        `);


        // Function to apply colors to Chosen.js selected items and dropdown options
        function applyChosenTagColors() {
            $('.picqer-tag-selector').each(function() {
                var $select = $(this);
                var selectId = $select.attr('id');
                
                if (typeof selectId === 'undefined' || selectId === null || selectId === '') {
                    return;
                }

                var $chosenContainer = $('#' + selectId + '_chosen');
                
                if ($chosenContainer.length === 0) {
                    return;
                }

                // Get all original options with their data attributes
                var optionsData = [];
                $select.find('option').each(function(index) {
                    optionsData[index] = {
                        bgColor: $(this).data('bgcolor'),
                        text: $(this).text().trim()
                    };
                });


                // Apply colors to selected tags in the chosen-choices list
                $chosenContainer.find('.chosen-choices li.search-choice').each(function() {
                    var $this = $(this);
                    var optionIndex = $this.data('option-array-index');

                    if (typeof optionIndex === 'undefined' || optionIndex === null || optionIndex === -1) {
                        var selectedText = $this.find('span').text().trim(); 
                        
                        if (selectedText === '') {
                            selectedText = $this.clone().children('.search-choice-close').remove().end().text().trim();
                        }

                        var foundIndex = -1;
                        for (var i = 0; i < optionsData.length; i++) {
                            if (optionsData[i].text === selectedText) {
                                foundIndex = i;
                                break;
                            }
                        }
                        optionIndex = foundIndex;
                    }
                    
                    if (typeof optionIndex !== 'undefined' && optionIndex !== -1 && optionsData[optionIndex] && $this.find('div.tagcolor').length === 0) {
                        var bgColor = optionsData[optionIndex].bgColor;
                        if (bgColor) {
                            $this.prepend('<div class="tagcolor" style="background-color: ' + bgColor + ' !important;"></div>');
                        }
                    }
                });

                // Apply colors to options in the dropdown list
                $chosenContainer.find('.chosen-results li.active-result').each(function() {
                    var $this = $(this);
                    var optionIndex = $this.data('option-array-index');

                    if (typeof optionIndex !== 'undefined' && optionsData[optionIndex]) {
                        var bgColor = optionsData[optionIndex].bgColor;
                        if (bgColor) {
                            $this.html('<div class="tagcolor" style="background-color: ' + bgColor + ' !important;"></div><span>' + $this.html() + '</span>');
                        }
                    }
                });

            });
        }


        // Apply colors on initial load
        setTimeout(applyChosenTagColors, 100);

        // Re-apply colors when Chosen.js updates (e.g., selection changes)
        $('.picqer-tag-selector').on('chosen:ready chosen:updated change chosen:showing_dropdown', function() {
            setTimeout(applyChosenTagColors, 50);
        });


        // This function will be used by both the dynamic toggle and the "Add New Mapping" button
        function addMappingRowTemplate() {
           
            var newRowHtml = `
            <tr>
                <td>
                    <select name="ps_from_status_id[]" class="form-control">
                        <option value="0">{l s='Any' mod='prestapicqer' js=1}</option>
                        {foreach from=$ps_order_statuses item=status}
                            <option value="{$status.id_order_state|intval}">{$status.name|escape:'htmlall':'UTF-8'}</option>
                        {/foreach}
                    </select>
                </td>
                <td>
                    <select name="picqer_status_name[]" class="form-control" required>
                        {foreach from=$picqer_statuses item=picqer_status}
                            <option value="{$picqer_status|escape:'htmlall':'UTF-8'}">{$picqer_statuses_translated[$picqer_status]|escape:'htmlall':'UTF-8'}</option>
                        {/foreach}
                    </select>
                </td>
                <td>
                    <select name="ps_to_status_id[]" class="form-control" required>
                        <option value="">{l s='-- Choose --' mod='prestapicqer' js=1}</option>
                        {foreach from=$ps_order_statuses item=status}
                            <option value="{$status.id_order_state|intval}">{$status.name|escape:'htmlall':'UTF-8'}</option>
                        {/foreach}
                    </select>
                </td>
                <td>
                    <button type="button" class="btn btn-danger remove-row" title="{l s='Remove' mod='prestapicqer'}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                            <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z"/>
                            <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z"/>
                        </svg>
                    </button>
                </td>
            </tr>`;

            $('#status_mapping_table tbody').append(newRowHtml);     
        }

        // Function to dynamically add/remove the initial empty row based on switch and existing mappings
        function toggleDynamicEmptyRow() {
            var isPullOrderStatusEnabled = $('#PRESTAPICQER_PULL_ORDER_STATUS_ENABLED_on').is(':checked');
            var $tbody = $('#status_mapping_table tbody');
            var currentRowsCount = $tbody.find('tr').length;

            if (isPullOrderStatusEnabled) {
                if (currentRowsCount === 0) {
                    addMappingRowTemplate();
                }
            } else {
                if (currentRowsCount === 1) {
                    var $firstRow = $tbody.find('tr').first();
                    var psFromStatus = $firstRow.find('select[name="ps_from_status_id[]"]').val();
                    var picqerStatus = $firstRow.find('select[name="picqer_status_name[]"]').val();
                    var psToStatus = $firstRow.find('select[name="ps_to_status_id[]"]').val();

                    if (psFromStatus === '0' && picqerStatus === '' && psToStatus === '') {
                        $firstRow.remove();
                    }
                }
            }
        }

        toggleDynamicEmptyRow();

        $('input[name="PRESTAPICQER_PULL_ORDER_STATUS_ENABLED"]').on('change', function() {
            toggleDynamicEmptyRow();

            if ($(this).val() == 1) {
                $('#orderStatusWebhookWarning').removeClass('hide');
            } else {
                $('#orderStatusWebhookWarning').addClass('hide');
            }
        });

        $('#add_mapping_row').on('click', function() {
            addMappingRowTemplate();
        });

        $(document).on('click', '.remove-row', function() {
            $(this).closest('tr').remove();
            toggleDynamicEmptyRow();
        });


        $('input[type="radio"][name="PRESTAPICQER_PULL_STOCK_ENABLED"]').on('change', function() {
            if ($(this).val() == 1) {
                $('#stockChangeWebhookWarning').removeClass('hide');
            } else {
                $('#stockChangeWebhookWarning').addClass('hide');
            }
        });


        const $passwordField = $('#picqerApiKey');

        $('#togglePassword').on('click', function() {
            const currentType = $passwordField.attr('type');

            if (currentType === 'password') {
                $passwordField.attr('type', 'text');
            } else {
                $passwordField.attr('type', 'password');
            }
        });

        if($passwordField.val().length){
            $passwordField.attr('type', 'password');
        }

        console.log("%c🙂", "color: red; font-size: xxx-large", 'from "https://softerbv.nl/prestapicqer"');
    });

</script>